
Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/quest_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 1.8, y = -22.86, z = 7, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["campaign"] = 
{
	active = true, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_campaign", 
	type = "quest", 
}

Triggers["go_out"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-64.2, x=-41.6, z=4.9, f=1 }, 
	priority = 1, 
	think = "tf_go_out", 
	type = "quest", 
}

Triggers["quest_0"] = 
{
	active = true, 
	effect_radius = 3, 
	position = { y=-59.6, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_quest_0", 
	type = "quest", 
}

Triggers["standart_finish"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_standart_finish", 
	type = "quest", 
}

Triggers["relations"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations", 
	type = "quest", 
}

Triggers["relations_vs_civ"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=140, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_civ", 
	type = "quest", 
}

Triggers["way_out"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 7, 
	point_radius = 0.5, 
	position = { y=-37.3, x=3, z=5.3, f=1 }, 
	transfer_mode = "run", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=2.96788, y=-37.2585, z=5.34848},{ x=-3.97985, y=-37.091, z=5.02858},{ x=-13.3216, y=-35.8928, z=4.26212},{ x=-21.6019, y=-40.2226, z=4.33768},{ x=-30.8623, y=-50.7532, z=4.66151},{ x=-37.0694, y=-58.1781, z=4.86381},{ x=-41.8545, y=-65.0732, z=4.97012} }
}

Triggers["relations_vs_minister"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=140, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_minister", 
	type = "quest", 
}

trigger_functions =
{
tf_campaign = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if (trigger.active == true) then
		if (getGVAR("SA_MINISTER_ALIVE") == _YES) then
			if (getGVAR("spawn_minister_sa") == _YES) then
				if (getGVAR("spawn_mara_sa") == _YES) then
					if (healthOK("mar_officer_01") == false) then
						trigger.active = false
						return
					end
					checkPointer("safari", trigger_id, {"mar_officer_01"}, "marauders_remark1", "marauders_remark2", "mar_officer_01", 10, time, false, 30, "marauders_remark3", false, 5)
				else
					trigger.active = false
				end
			else
				trigger.active = false
			end
		else
			trigger.active = false
		end
	end
end,
tf_go_out = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.delay(trigger_id, 2.00) ) then
			if (getGVAR("SA_MINISTER_ALIVE") == _YES) then
				if (getGVAR("spawn_minister_sa") == _YES) then
					if (getGVAR("spawn_mara_sa") == _YES) then
						log("safari", "ATTEMPT TO GO OUT")
						Humans["ex_minister"].behavior = "patrol"
						Humans["ex_minister"].patrol_routine = "way_out"			
						trigger_utility.resetDelay(trigger_id)
					end
				end
--			trigger.active = false
			end
		end
	end
end,
tf_quest_0 = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if (getGVAR("SA_MINISTER_ALIVE") == _YES) then
			if (getGVAR("spawn_minister_sa") == _YES) then
				if (getGVAR("spawn_mara_sa") == _YES) then
					if(trigger_utility.isPersonPresent(trigger_id,"ex_minister") ) then
						Triggers["go_out"].active = false
						Humans["ex_minister"].behavior = "civilian"
						Humans["ex_minister"].patrol_routine = ""
						if (healthOK("mar_officer_01")) then
							local cm = getClosestMerc("mar_officer_01")
							startDlg("mar_officer_02", cm, "mar_officer_01")
						end
						disappearHuman("ex_minister")
						
						setGVAR("spawn_minister_sa", _NO)
						
						--log("___quest_debug", "SAFARI", "minister despawned", getGVAR("spawn_minister_sa"))
						
						CUR_MISSION.Success = true
						trigger.active = false
					end
				end
			end
		end
	end
end,
tf_relations = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		log("safari", "ATTEMPT TO CHANGE RELATIONS VS MARA")
		changeLocalRelations(ENEMY, MARAUDERS)
		changeLocalRelations(ENEMY, CIVILIANS, MARAUDERS)
		changeLocalRelations(ENEMY, "quest_npc", MARAUDERS)
		trigger.active = false
	end
end,
tf_relations_vs_civ = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		log("safari", "ATTEMPT TO CHANGE RELATIONS VS CIV")
		changeLocalRelations(ENEMY, CIVILIANS)
		changeLocalRelations(ENEMY, CIVILIANS, MARAUDERS)
		changeLocalRelations(ENEMY, "quest_npc")
		changeLocalRelations(ENEMY, "quest_npc", MARAUDERS)
--		Sectors.safari.isMaraGotHelp = true
		trigger.active = false
	end
end,
tf_standart_finish = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if (messageBox("confirm_leave_location", YES_NO, SMALL) == YES) then
			CUR_MISSION.Success = true
			finishMission(false)
		else
			Triggers["relations"].active = true
		end
		trigger.active = false
	end
end,
tf_relations_vs_minister = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, "quest_npc")
		trigger.active = false
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- quest watcher trigger
--
tf_quest_watcher = CommonTriggers.quest_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}

